<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Verify
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MagicLogin\Dependencies\Twilio\Rest\Verify;

use MagicLogin\Dependencies\Twilio\Domain;
use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\InstanceContext;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\FormList;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\SafelistList;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\ServiceList;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\TemplateList;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\VerificationAttemptList;
use MagicLogin\Dependencies\Twilio\Rest\Verify\V2\VerificationAttemptsSummaryList;
use MagicLogin\Dependencies\Twilio\Version;

/**
 * @property FormList $forms
 * @property SafelistList $safelist
 * @property ServiceList $services
 * @property TemplateList $templates
 * @property VerificationAttemptList $verificationAttempts
 * @property VerificationAttemptsSummaryList $verificationAttemptsSummary
 * @method \MagicLogin\Dependencies\Twilio\Rest\Verify\V2\FormContext forms(string $formType)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Verify\V2\SafelistContext safelist(string $phoneNumber)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Verify\V2\ServiceContext services(string $sid)
 * @method \MagicLogin\Dependencies\Twilio\Rest\Verify\V2\VerificationAttemptContext verificationAttempts(string $sid)
 */
class V2 extends Version
{
    protected $_forms;
    protected $_safelist;
    protected $_services;
    protected $_templates;
    protected $_verificationAttempts;
    protected $_verificationAttemptsSummary;

    /**
     * Construct the V2 version of Verify
     *
     * @param Domain $domain Domain that contains the version
     */
    public function __construct(Domain $domain)
    {
        parent::__construct($domain);
        $this->version = 'v2';
    }

    protected function getForms(): FormList
    {
        if (!$this->_forms) {
            $this->_forms = new FormList($this);
        }
        return $this->_forms;
    }

    protected function getSafelist(): SafelistList
    {
        if (!$this->_safelist) {
            $this->_safelist = new SafelistList($this);
        }
        return $this->_safelist;
    }

    protected function getServices(): ServiceList
    {
        if (!$this->_services) {
            $this->_services = new ServiceList($this);
        }
        return $this->_services;
    }

    protected function getTemplates(): TemplateList
    {
        if (!$this->_templates) {
            $this->_templates = new TemplateList($this);
        }
        return $this->_templates;
    }

    protected function getVerificationAttempts(): VerificationAttemptList
    {
        if (!$this->_verificationAttempts) {
            $this->_verificationAttempts = new VerificationAttemptList($this);
        }
        return $this->_verificationAttempts;
    }

    protected function getVerificationAttemptsSummary(): VerificationAttemptsSummaryList
    {
        if (!$this->_verificationAttemptsSummary) {
            $this->_verificationAttemptsSummary = new VerificationAttemptsSummaryList($this);
        }
        return $this->_verificationAttemptsSummary;
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     * @return \MagicLogin\Dependencies\Twilio\ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get(string $name)
    {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments): InstanceContext
    {
        $property = $this->$name;
        if (\method_exists($property, 'getContext')) {
            return \call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        return '[Twilio.Verify.V2]';
    }
}
