<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Flex
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace MagicLogin\Dependencies\Twilio\Rest\FlexApi\V1;

use MagicLogin\Dependencies\Twilio\Exceptions\TwilioException;
use MagicLogin\Dependencies\Twilio\Options;
use MagicLogin\Dependencies\Twilio\Values;
use MagicLogin\Dependencies\Twilio\Version;
use MagicLogin\Dependencies\Twilio\InstanceContext;


class PluginVersionArchiveContext extends InstanceContext
    {
    /**
     * Initialize the PluginVersionArchiveContext
     *
     * @param Version $version Version that contains the resource
     * @param string $pluginSid The SID of the Flex Plugin the resource to belongs to.
     * @param string $sid The SID of the Flex Plugin Version resource to archive.
     */
    public function __construct(
        Version $version,
        $pluginSid,
        $sid
    ) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [
        'pluginSid' =>
            $pluginSid,
        'sid' =>
            $sid,
        ];

        $this->uri = '/PluginService/Plugins/' . \rawurlencode($pluginSid)
        .'/Versions/' . \rawurlencode($sid)
        .'/Archive';
    }

    /**
     * Update the PluginVersionArchiveInstance
     *
     * @param array|Options $options Optional Arguments
     * @return PluginVersionArchiveInstance Updated PluginVersionArchiveInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(array $options = []): PluginVersionArchiveInstance
    {

        $options = new Values($options);

        $headers = Values::of(['Content-Type' => 'application/x-www-form-urlencoded' , 'Flex-Metadata' => $options['flexMetadata']]);
        $payload = $this->version->update('POST', $this->uri, [], [], $headers);

        return new PluginVersionArchiveInstance(
            $this->version,
            $payload,
            $this->solution['pluginSid'],
            $this->solution['sid']
        );
    }


    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.FlexApi.V1.PluginVersionArchiveContext ' . \implode(' ', $context) . ']';
    }
}
