<?php
/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * MagicLogin\Dependencies\Twilio - Chat
 * This is the public MagicLogin\Dependencies\Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MagicLogin\Dependencies\Twilio\Rest\Chat\V2\Service;

use MagicLogin\Dependencies\Twilio\Options;
use MagicLogin\Dependencies\Twilio\Values;

abstract class UserOptions
{
    /**
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the new User.
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @param string $friendlyName A descriptive string that you create to describe the new resource. This value is often used for display purposes.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     * @return CreateUserOptions Options builder
     */
    public static function create(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE,
        string $xTwilioWebhookEnabled = Values::NONE

    ): CreateUserOptions
    {
        return new CreateUserOptions(
            $roleSid,
            $attributes,
            $friendlyName,
            $xTwilioWebhookEnabled
        );
    }




    /**
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the User.
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @param string $friendlyName A descriptive string that you create to describe the resource. It is often used for display purposes.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     * @return UpdateUserOptions Options builder
     */
    public static function update(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE,
        string $xTwilioWebhookEnabled = Values::NONE

    ): UpdateUserOptions
    {
        return new UpdateUserOptions(
            $roleSid,
            $attributes,
            $friendlyName,
            $xTwilioWebhookEnabled
        );
    }

}

class CreateUserOptions extends Options
    {
    /**
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the new User.
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @param string $friendlyName A descriptive string that you create to describe the new resource. This value is often used for display purposes.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     */
    public function __construct(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE,
        string $xTwilioWebhookEnabled = Values::NONE

    ) {
        $this->options['roleSid'] = $roleSid;
        $this->options['attributes'] = $attributes;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
    }

    /**
     * The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the new User.
     *
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the new User.
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self
    {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * A valid JSON string that contains application-specific data.
     *
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self
    {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * A descriptive string that you create to describe the new resource. This value is often used for display purposes.
     *
     * @param string $friendlyName A descriptive string that you create to describe the new resource. This value is often used for display purposes.
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The X-Twilio-Webhook-Enabled HTTP request header
     *
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     * @return $this Fluent Builder
     */
    public function setXTwilioWebhookEnabled(string $xTwilioWebhookEnabled): self
    {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Chat.V2.CreateUserOptions ' . $options . ']';
    }
}




class UpdateUserOptions extends Options
    {
    /**
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the User.
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @param string $friendlyName A descriptive string that you create to describe the resource. It is often used for display purposes.
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     */
    public function __construct(
        
        string $roleSid = Values::NONE,
        string $attributes = Values::NONE,
        string $friendlyName = Values::NONE,
        string $xTwilioWebhookEnabled = Values::NONE

    ) {
        $this->options['roleSid'] = $roleSid;
        $this->options['attributes'] = $attributes;
        $this->options['friendlyName'] = $friendlyName;
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
    }

    /**
     * The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the User.
     *
     * @param string $roleSid The SID of the [Role](https://www.twilio.com/docs/chat/rest/role-resource) to assign to the User.
     * @return $this Fluent Builder
     */
    public function setRoleSid(string $roleSid): self
    {
        $this->options['roleSid'] = $roleSid;
        return $this;
    }

    /**
     * A valid JSON string that contains application-specific data.
     *
     * @param string $attributes A valid JSON string that contains application-specific data.
     * @return $this Fluent Builder
     */
    public function setAttributes(string $attributes): self
    {
        $this->options['attributes'] = $attributes;
        return $this;
    }

    /**
     * A descriptive string that you create to describe the resource. It is often used for display purposes.
     *
     * @param string $friendlyName A descriptive string that you create to describe the resource. It is often used for display purposes.
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The X-Twilio-Webhook-Enabled HTTP request header
     *
     * @param string $xTwilioWebhookEnabled The X-Twilio-Webhook-Enabled HTTP request header
     * @return $this Fluent Builder
     */
    public function setXTwilioWebhookEnabled(string $xTwilioWebhookEnabled): self
    {
        $this->options['xTwilioWebhookEnabled'] = $xTwilioWebhookEnabled;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Chat.V2.UpdateUserOptions ' . $options . ']';
    }
}

